<?php

namespace Tests\Feature\Http\Controllers\Api;

use App\Models\NewsletterSubscriber;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Illuminate\Support\Facades\Notification;
use Tests\TestCase;

class NewsletterSubscribersControllerTest extends TestCase
{
    use RefreshDatabase;

    public function test_user_can_subscribe_with_valid_email()
    {
        $email = 'test@example.com';

        $response = $this->postJson('/api/newsletter-subscribers', [
            'data' => [
                'attributes' => [
                    'email' => $email,
                ],
            ],
        ]);

        $response->assertStatus(201)
            ->assertJson([
                'data' => [
                    'type' => 'newsletter-subscriber',
                    'attributes' => [
                        'email' => $email,
                    ],
                ],
            ]);

        $this->assertDatabaseHas('newsletter_subscribers', [
            'email' => $email,
        ]);
    }

    public function test_user_cannot_subscribe_with_invalid_email()
    {
        $response = $this->postJson('/api/newsletter-subscribers', [
            'data' => [
                'attributes' => [
                    'email' => 'not-an-email',
                ],
            ],
        ]);

        $response->assertStatus(422)
            ->assertJsonValidationErrors('email');
    }

    public function test_user_cannot_subscribe_with_existing_email()
    {
        $email = 'duplicate@example.com';
        NewsletterSubscriber::create(['email' => $email]);

        $response = $this->postJson('/api/newsletter-subscribers', [
            'data' => [
                'attributes' => [
                    'email' => $email,
                ],
            ],
        ]);

        $response->assertStatus(409)
            ->assertJson([
                'message' => 'This email is already subscribed.',
            ]);
    }
}
