<?php

namespace Tests\Feature\Http\Controllers\Api;

use App\Http\Resources\SocialLinkResource;
use App\Models\SocialLink;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Tests\TestCase;

class SocialsControllerTest extends TestCase
{
    use RefreshDatabase;

    public function test_it_returns_socials(): void
    {
        $socials = SocialLink::factory()->count(3)->create();
        $resource = SocialLinkResource::collection($socials);

        $this->get(route('api.socials.index', ['lang' => 'en']))
            ->assertOk()
            ->assertJson($resource->response()->getData(true));
    }
}
