<?php

namespace Tests\Feature\Http\Controllers\Web;

use App\Http\Resources\PrivacyPolicyPageResource;
use App\Support\PrivacyPolicyPage;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Tests\TestCase;

class PrivacyPolicyPageControllerTest extends TestCase
{
    use RefreshDatabase;

    public function test_it_returns_privacy_policy()
    {
        PrivacyPolicyPage::make()->body()->patch([
            'content' => ['en' => 'privacy content'],
            'description' => ['en' => 'privacy description'],
        ]);

        $resource = PrivacyPolicyPageResource::make(PrivacyPolicyPage::make());

        $this->get(route('api.pages.privacy-policy.index', ['lang' => 'en']))->assertOk()
            ->assertExactJson($resource->response()->getData(true));
    }
}
