<?php ($brandColor = '#0f1840'); ?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <title>New Request</title>
</head>

<body
    style="margin:0;padding:0;background:#f5f7fa;font-family:-apple-system,BlinkMacSystemFont,'Segoe UI',Roboto,'Helvetica Neue',Arial,sans-serif;">
    <table role="presentation" width="100%" cellpadding="0" cellspacing="0" style="background:#f5f7fa;padding:30px 0;">
        <tr>
            <td align="center">
                <!--[if (gte mso 9)|(IE)]><table width="600"><tr><td><![endif]-->
                <table role="presentation" width="100%" cellpadding="0" cellspacing="0"
                    style="max-width:600px;background:#ffffff;border-radius:8px;box-shadow:0 2px 6px rgba(0,0,0,.05);overflow:hidden;">

                    
                    <tr>
                        <td
                            style="background:<?php echo e($brandColor); ?>;color:#ffffff;padding:16px 24px;font-size:20px;font-weight:600;text-align:center;">
                            New Request Received
                        </td>
                    </tr>

                    
                    <tr>
                        <td style="padding:24px;">
                            <p style="margin:0 0 16px;font-size:16px;line-height:1.4;">Hi&nbsp;there,</p>
                            <p style="margin:0 0 24px;font-size:16px;line-height:1.4;">
                                You have a new request with the following details:
                            </p>

                            <table role="presentation" cellpadding="0" cellspacing="0"
                                style="width:100%;font-size:15px;line-height:1.5;">
                                <tr>
                                    <td style="padding:8px 0;width:35%;color:#6c757d;">Name:</td>
                                    <td style="padding:8px 0;"><?php echo e($data['name']); ?></td>
                                </tr>
                                <tr>
                                    <td style="padding:8px 0;color:#6c757d;">Email:</td>
                                    <td style="padding:8px 0;"><?php echo e($data['email']); ?></td>
                                </tr>
                                <tr>
                                    <td style="padding:8px 0;color:#6c757d;">Phone&nbsp;Number:</td>
                                    <td style="padding:8px 0;"><?php echo e($data['phone_number']); ?></td>
                                </tr>
                                <?php if($data['message']): ?>
                                <tr>
                                    <td style="padding:8px 0;color:#6c757d;">Message:</td>
                                    <td style="padding:8px 0;"><?php echo e($data['message']); ?></td>
                                </tr>
                                <?php endif; ?>
                                <?php if($data['date']): ?>
                                <tr>
                                    <td style="padding:8px 0;color:#6c757d;">Date:</td>
                                    <td style="padding:8px 0;"><?php echo e($data['date']); ?></td>
                                </tr>
                                <?php endif; ?>
                                <?php if($data['time']): ?>
                                <tr>
                                    <td style="padding:8px 0;color:#6c757d;">Time:</td>
                                    <td style="padding:8px 0;"><?php echo e($data['time']); ?></td>
                                </tr>
                                <?php endif; ?>
                                <tr>
                                    <td style="padding:8px 0;color:#6c757d;">Type:</td>
                                    <td style="padding:8px 0;"><?php echo e(\Illuminate\Support\Str::ucfirst($data['type'])); ?>

                                    </td>
                                </tr>
                                <tr>
                                    <td style="padding:8px 0;color:#6c757d;">Type&nbsp;Name:</td>
                                    <td style="padding:8px 0;"><?php echo e($data['typeName']); ?></td>
                                </tr>
                            </table>

                            
                            <div style="text-align:center;margin:32px 0 0;">
                                <a <?php if($data['type']=="service" ): ?> href="#"
                                    <?php elseif($data['type']=="package" ): ?> href="#" <?php else: ?>
                                    href="#" <?php endif; ?>
                                    style="background:<?php echo e($brandColor); ?>;color:#ffffff;text-decoration:none;padding:12px 24px;border-radius:4px;display:inline-block;font-weight:600;font-size:15px;">
                                    View in Dashboard
                                </a>
                            </div>

                            <p style="margin:32px 0 0;font-size:14px;color:#6c757d;text-align:center;">
                                © <?php echo e(date('Y')); ?> Alsarh Individual Hospitality
                            </p>
                        </td>
                    </tr>
                </table>
                <!--[if (gte mso 9)|(IE)]></td></tr></table><![endif]-->
            </td>
        </tr>
    </table>
</body>

</html><?php /**PATH /home/individualhosp/public_html/dashboard/resources/views/emails/internal_new_request_notification.blade.php ENDPATH**/ ?>