<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <title><?php echo e($subject); ?></title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
</head>
<body style="margin:0; padding:0; background:#f7f7f7;">
  <!-- Wrapper table (best for email clients) -->
  <table role="presentation" cellpadding="0" cellspacing="0" width="100%" style="background:#f7f7f7;">
    <tr>
      <td align="center" style="padding:24px;">
        <table role="presentation" cellpadding="0" cellspacing="0" width="640" style="max-width:640px; background:#ffffff; border-radius:12px; overflow:hidden;">
          <!-- Header -->
          <tr>
            <td style="padding:24px 24px 0 24px; font-family:Arial,Helvetica,sans-serif;">
              <h1 style="margin:0 0 8px 0; font-size:22px; line-height:1.3; color:#111111;">
                <?php echo e($subject); ?>

              </h1>
            </td>
          </tr>

          <!-- Body -->
          <tr>
            <td style="padding:16px 24px 24px 24px; font-family:Arial,Helvetica,sans-serif; color:#111111;">
              <div style="font-size:14px; line-height:1.7; white-space:pre-wrap;">
                <?php echo nl2br(e($body)); ?>

              </div>
            </td>
          </tr>

          <!-- Optional image at the END -->
          <?php if(!empty($imageUrl)): ?>
            <tr>
              <td style="padding:0 24px 24px 24px; font-family:Arial,Helvetica,sans-serif;">
                <img src="<?php echo e($imageUrl); ?>" alt="" width="592"
                     style="display:block; width:100%; max-width:592px; height:auto; border:0; border-radius:10px;">
              </td>
            </tr>
          <?php endif; ?>

          <!-- Divider -->
          <tr>
            <td style="padding:0 24px;">
              <hr style="border:0; border-top:1px solid #e5e7eb; margin:0;">
            </td>
          </tr>

          <!-- Footer -->
          <tr>
            <td style="padding:16px 24px 24px 24px; font-family:Arial,Helvetica,sans-serif; color:#666666;">
              <p style="margin:0; font-size:12px; line-height:1.6;">
                © <?php echo e(date('Y')); ?> <?php echo e(config('app.name')); ?>. All rights reserved.
              </p>
            </td>
          </tr>
        </table>
      </td>
    </tr>
  </table>
</body>
</html>
<?php /**PATH /home/individualhosp/public_html/dashboard/resources/views/emails/newsletter.blade.php ENDPATH**/ ?>