<?php

use App\Http\Controllers\Api\ContactMessageController;
use App\Http\Controllers\Api\SocialsController;
use App\Http\Controllers\Api\NewsletterSubscribersController;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Api\PrivacyPolicyPageController;
use App\Http\Controllers\Api\PageController;
use App\Http\Controllers\Api\TermsAndConditionsPageController;
use App\Http\Controllers\Api\HomePageController;
use App\Http\Controllers\Api\WhoWeArePageController;
use App\Http\Controllers\Api\OurServicesPageController;
use App\Http\Controllers\Api\OurServicesController;
use App\Http\Controllers\Api\OurPackagesPageController;
use App\Http\Controllers\Api\YourPackagePageController;
use App\Http\Controllers\Api\PackagesController;
use App\Http\Controllers\Api\PackagesTypeController;
use App\Http\Controllers\Api\ContactUsController;
use App\Http\Controllers\Api\RequestController;
use App\Http\Controllers\Api\StatisticsController;
use App\Http\Controllers\Api\NewsletterController;



Route::get("/test-email", [SocialsController::class, "testEmail"])->name(
    "api.socials.test-email"
);


Route::get("/socials", [SocialsController::class, "index"])->name(
    "api.socials.index"
);

Route::post("/contact-messages", [
    ContactMessageController::class,
    "store",
])->name("api.contact-messages.store");


Route::post("/newsletter/subscribers", [
    NewsletterSubscribersController::class,
    "store",
])->name("api.newsletter-subscribers.store");


Route::get("/pages/privacy-policy", [
    PrivacyPolicyPageController::class,
    "index",
])->name("api.pages.privacy-policy.index");

Route::get("/pages/terms-and-conditions", [
    TermsAndConditionsPageController::class,
    "index",
])->name("api.pages.terms-and-conditions.index");

Route::get("/pages/home", [HomePageController::class, "index"])->name(
    "api.pages.home.index"
);

Route::get("/pages/who-we-are", [WhoWeArePageController::class, "index"])->name(
    "api.pages.who-we-are.index"
);

Route::get("/pages/our-services", [OurServicesPageController::class, "index"])->name(
    "api.pages.our-services-page.index"
);

Route::get("/our-services", [OurServicesController::class, "index"])->name(
    "api.pages.our-services.index"
);

Route::get("our-services/show/{id}", [OurServicesController::class, "show"])->name(
    "api.pages.our-services.show"
);

Route::get("pages/our-packages", [OurPackagesPageController::class, "index"])->name(
    "api.pages.our-packages.index"
);

Route::get("pages/your-package", [YourPackagePageController::class, "index"])->name(
    "api.pages.your-package.index"
);

Route::get("packages-type", [PackagesTypeController::class, "index"])->name(
    "api.pages.packages-type.index"
);

Route::get("packages", [PackagesController::class, "index"])->name(
    "api.pages.packages.index"
);

Route::get("packages/show/{id}", [PackagesController::class, "show"])->name(
    "api.pages.packages.show"
);

Route::get("pages/contact-us", [ContactUsController::class, "index"])->name(
    "api.pages.contact-us.index"
);

Route::post("/request", [
    RequestController::class,
    "store",
])->name("api.request.store");

Route::get("pages/statistics", [StatisticsController::class, "index"])->name(
    "api.pages.statistics.index"
);

Route::get("pages/newsletter", [NewsletterController::class, "index"])->name(
    "api.pages.newsletter.index"
);
