@php
    $brandColor = '#0f1840';
    $muted = '#6B7280';
@endphp
<!DOCTYPE html>
<html lang="en" dir="ltr">
<head>
  <meta charset="utf-8">
  <title>We’ve received your request</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
</head>
<body style="margin:0;padding:0;background:#f5f7fb;">
  <table role="presentation" cellspacing="0" cellpadding="0" border="0" width="100%" style="background:#f5f7fb;">
    <tr>
      <td align="center" style="padding:24px;">
        <table role="presentation" cellspacing="0" cellpadding="0" border="0" width="100%" style="max-width:640px;background:#ffffff;border-radius:12px;overflow:hidden;box-shadow:0 6px 24px rgba(15,24,64,0.10);">
          
          <!-- Header -->
          <tr>
            <td style="background:{{ $brandColor }};padding:20px 24px;">
              <table width="100%" role="presentation">
                <tr>
                  <td align="left" style="color:#E5E7EB;font:700 16px/1.2 -apple-system,BlinkMacSystemFont,'Segoe UI',Roboto,Helvetica,Arial;">
                    Alsarh Individual Hospitality
                  </td>
                  <td align="right" style="color:#D1FAE5;font:500 13px/1.2 -apple-system,BlinkMacSystemFont,'Segoe UI',Roboto,Helvetica,Arial;">
                    Request Confirmation
                  </td>
                </tr>
              </table>
            </td>
          </tr>

          <!-- Body -->
          <tr>
            <td style="padding:28px 24px 8px 24px;font:400 16px/1.6 -apple-system,BlinkMacSystemFont,'Segoe UI',Roboto,Helvetica,Arial;color:#111827;">
              
              <!-- Small badge -->
              <div style="display:inline-block;background:#e0f2fe;color:#0369a1;padding:6px 10px;border-radius:999px;font:600 12px/1 -apple-system,BlinkMacSystemFont,'Segoe UI',Roboto,Helvetica,Arial;margin-bottom:10px;">
                Request Received
              </div>

              <h2 style="margin:8px 0 12px 0;font:700 22px/1.3 -apple-system,BlinkMacSystemFont,'Segoe UI',Roboto,Helvetica,Arial;color:#0b1220;">
                Hello {{ $data['name'] }},
              </h2>

              <p style="margin:0 0 12px 0;">
                Thank you for your interest in our {{ $data['typeName'] }} {{ $data['type'] == 'package' ? 'Package' : 'Service' }}.
                We have received your request and one of our representatives will contact you shortly to provide more details.
              </p>

              @isset($data['message'])
                <div style="margin:16px 0;padding:12px 14px;border:1px solid #e5e7eb;border-radius:10px;background:#fafafa;">
                  <div style="font-weight:600;margin-bottom:6px;">Your Message</div>
                  <div style="white-space:pre-wrap;color:#1f2937;">{{ $data['message'] }}</div>
                </div>
              @endisset

              @if(!empty($data['date']) || !empty($data['time']))
                <div style="margin:12px 0;padding:10px 14px;border-left:4px solid {{ $brandColor }};background:#f9fafb;border-radius:6px;">
                  <div style="font-weight:600;margin-bottom:4px;">Requested Schedule</div>
                  <div style="color:#1f2937;">
                    @if(!empty($data['date'])) 📅 {{ $data['date'] }} @endif
                    @if(!empty($data['time'])) 🕒 {{ $data['time'] }} @endif
                  </div>
                </div>
              @endif

              <table role="presentation" cellspacing="0" cellpadding="0" border="0" style="margin:18px 0;">
                <tr>
                  <td>
                    <a href="https://individual-hospitality-frontend.vercel.app"
                       style="background:{{ $brandColor }};color:#ffffff;text-decoration:none;padding:12px 18px;border-radius:10px;display:inline-block;font:600 14px/1 -apple-system,BlinkMacSystemFont,'Segoe UI',Roboto,Helvetica,Arial;"
                       target="_blank">
                      Explore More Offers
                    </a>
                  </td>
                </tr>
              </table>

              <p style="margin:6px 0 0 0;color:{{ $muted }};font-size:13px;">
                If you did not submit this request, please reply to this email to let us know.
              </p>
            </td>
          </tr>

          <!-- Divider -->
          <tr>
            <td style="padding:0 24px;">
              <hr style="border:none;border-top:1px solid #eef1f5;margin:8px 0;">
            </td>
          </tr>

          <!-- Footer -->
          <tr>
            <td style="padding:12px 24px 24px 24px;color:{{ $muted }};font:400 12px/1.6 -apple-system,BlinkMacSystemFont,'Segoe UI',Roboto,Helvetica,Arial;">
              Best regards,<br>
              <strong style="color:#111827;">Alsarh Individual Hospitality Team</strong><br>
              <a href="mailto:Sales@vendor.alsarhindvhospitality.com" style="color:{{ $muted }};text-decoration:none;">Sales@vendor.alsarhindvhospitality.com</a><br>
              <span style="opacity:.8;">&copy; {{ date('Y') }} Alsarh Individual Hospitality. All rights reserved.</span>
            </td>
          </tr>
        </table>

        <div style="max-width:640px;margin-top:10px;color:#9CA3AF;font:400 11px/1.6 -apple-system,BlinkMacSystemFont,'Segoe UI',Roboto,Helvetica,Arial;">
          You’re receiving this email because you requested one of our services or packages.
        </div>
      </td>
    </tr>
  </table>
</body>
</html>
