@php
    $brandColor = '#0f1840';
    $muted = '#6B7280';
@endphp
<!DOCTYPE html>
<html lang="en" dir="ltr">
<head>
  <meta charset="utf-8">
  <title>We received your request</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
</head>
<body style="margin:0;padding:0;background:#f5f7fb;">
  <table role="presentation" cellspacing="0" cellpadding="0" border="0" width="100%" style="background:#f5f7fb;">
    <tr>
      <td align="center" style="padding:24px;">
        <table role="presentation" cellspacing="0" cellpadding="0" border="0" width="100%" style="max-width:640px;background:#ffffff;border-radius:12px;overflow:hidden;box-shadow:0 6px 24px rgba(15,24,64,0.10);">
          <!-- Header -->
          <tr>
            <td style="background:{{ $brandColor }};padding:20px 24px;">
              <table width="100%" role="presentation">
                <tr>
                  <td align="left" style="color:#E5E7EB;font:700 16px/1.2 -apple-system,BlinkMacSystemFont,'Segoe UI',Roboto,Helvetica,Arial;">
                    Alsarh Individual Hospitality
                  </td>
                  <td align="right" style="color:#D1FAE5;font:500 13px/1.2 -apple-system,BlinkMacSystemFont,'Segoe UI',Roboto,Helvetica,Arial;">
                    Contact Confirmation
                  </td>
                </tr>
              </table>
            </td>
          </tr>

          <!-- Body -->
          <tr>
            <td style="padding:28px 24px 8px 24px;font:400 16px/1.6 -apple-system,BlinkMacSystemFont,'Segoe UI',Roboto,Helvetica,Arial;color:#111827;">
              
              <!-- Small badge -->
              <div style="display:inline-block;background:#eef2ff;color:#3730a3;padding:6px 10px;border-radius:999px;font:600 12px/1 -apple-system,BlinkMacSystemFont,'Segoe UI',Roboto,Helvetica,Arial;margin-bottom:10px;">
                We received your request
              </div>

              <h2 style="margin:8px 0 12px 0;font:700 22px/1.3 -apple-system,BlinkMacSystemFont,'Segoe UI',Roboto,Helvetica,Arial;color:#0b1220;">
                Hello {{ $clientName }},
              </h2>

              <p style="margin:0 0 12px 0;">
                Thanks for contacting us. Your request has been received and our team will get back to you soon.
              </p>

              @isset($previewMessage)
                <div style="margin:16px 0;padding:12px 14px;border:1px solid #e5e7eb;border-radius:10px;background:#fafafa;">
                  <div style="font-weight:600;margin-bottom:6px;">Your Message</div>
                  <div style="white-space:pre-wrap;color:#1f2937;">{{ $previewMessage }}</div>
                </div>
              @endisset

              <table role="presentation" cellspacing="0" cellpadding="0" border="0" style="margin:18px 0;">
                <tr>
                  <td>
                    <a href="https://individual-hospitality-frontend.vercel.app" target="_blank"
                       style="background:{{ $brandColor }};color:#ffffff;text-decoration:none;padding:12px 18px;border-radius:10px;display:inline-block;font:600 14px/1 -apple-system,BlinkMacSystemFont,'Segoe UI',Roboto,Helvetica,Arial;">
                      Visit Our Website
                    </a>
                  </td>
                </tr>
              </table>

              <p style="margin:6px 0 0 0;color:{{ $muted }};font-size:13px;">
                If you didn’t make this request, please reply to this email to let us know.
              </p>
            </td>
          </tr>

          <!-- Divider -->
          <tr>
            <td style="padding:0 24px;">
              <hr style="border:none;border-top:1px solid #eef1f5;margin:8px 0;">
            </td>
          </tr>

          <!-- Footer -->
          <tr>
            <td style="padding:12px 24px 24px 24px;color:{{ $muted }};font:400 12px/1.6 -apple-system,BlinkMacSystemFont,'Segoe UI',Roboto,Helvetica,Arial;">
              Best regards,<br>
              <strong style="color:#111827;">Alsarh Individual Hospitality</strong><br>
              <a href="mailto:Info@vendor.alsarhindvhospitality.com" style="color:{{ $muted }};text-decoration:none;">Info@vendor.alsarhindvhospitality.com</a><br>
              <span style="opacity:.8;">&copy; {{ date('Y') }} Alsarh Individual Hospitality. All rights reserved.</span>
            </td>
          </tr>
        </table>

        <div style="max-width:640px;margin-top:10px;color:#9CA3AF;font:400 11px/1.6 -apple-system,BlinkMacSystemFont,'Segoe UI',Roboto,Helvetica,Arial;">
          You’re getting this email because you contacted Alsarh Individual Hospitality.
        </div>
      </td>
    </tr>
  </table>
</body>
</html>
