<?php

namespace Database\Seeders;

use App\Enums\Role;
use App\Models\ContactMessage;
use App\Models\Customer;
use App\Models\LocalTalent;
use App\Models\SocialLink;
use App\Models\User;
use Illuminate\Database\Seeder;

use Database\Seeders\NewsletterSubscriberSeeder;

class DatabaseSeeder extends Seeder
{
    public function run(): void
    {
        $this->call(AuthorizationSeeder::class);
        $this->call(NewsletterSubscriberSeeder::class);

        // User::factory(10)->create();

        $admin = User::factory()->create([
            "name" => "John Doe",
            "email" => "admin@example.com",
        ]);

        $admin->assignRole(Role::admin);

        SocialLink::factory()->count(5)->create();

        ContactMessage::factory()->count(10)->create();

        // $customers = Customer::factory()->count(10)->create();
        // foreach ($customers as $customer) {
        //     $customer->user->assignRole(Role::customer);
        // }
        $localTalents = LocalTalent::factory()->count(50)->create();
        $clients = \App\Models\Client::factory()->count(5)->create();
        $partners = \App\Models\Partner::factory()->count(5)->create();
        $projects = \App\Models\Project::factory()->count(240)->create();

        $news = \App\Models\News::factory()->count(180)->create();
        $solutions = \App\Models\Solution::factory()->count(10)->create();
    }
}
