<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('package_services', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('package_id');
            $table->unsignedBigInteger('our_service_id');
            $table->integer("count");
            $table->boolean("status")->default(1);
            $table->foreign('package_id')->references('id')->on('packages')->cascadeOnDelete()->cascadeOnUpdate();
            $table->foreign('our_service_id')->references('id')->on('our_services')->cascadeOnDelete()->cascadeOnUpdate();
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('package_services');
    }
};
