<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('packages', function (Blueprint $table) {
            $table->id();
            $table->json("title");
            $table->unsignedBigInteger("package_type_id");
            $table->integer("validity");
            $table->enum("validity_type", ["days", "months", "years"]);
            $table->double("price", 8, 2);
            $table->double("discount_rate");
            $table->double("extra_discount_rate")->nullable();
            $table->foreign("package_type_id")->references("id")->on("package_types")->cascadeOnDelete()->cascadeOnUpdate();
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('packages');
    }
};
