<?php

namespace Database\Factories;

class SitePageFactory extends BaseFactory
{
    public function definition(): array
    {
        return [
            'key' => $this->faker->unique()->word(),
            'content' => [
                'hero' => [
                    'title' => $this->localized(fn(): string => $this->faker->sentence),
                    'subtitle' => $this->localized(fn(): string => $this->faker->sentence),
                ],
                'seo' => [
                    'title' => $this->localized(fn(): string => $this->faker->sentence),
                    'description' => $this->localized(fn(): string => $this->faker->paragraph),
                    'keywords' => $this->localized(fn(): string => $this->faker->words(3, true)),
                ],
            ],
        ];
    }
}
