<?php

namespace App\Support;

class WhoWeArePage extends Page
{
    public function key(): string
    {
        return 'who-we-are';
    }

    public function header(): Section
    {
        return $this->get('header', [
            'title' => [
                'en' => 'Who We Are',
                'ar' => 'من نحن',
            ],
            'description' => [
                'en' => 'Hotel-style service and more in your home Save time on household chores and daily tasks!',
                'ar' => 'خدمة على طراز الفنادق وأكثر في منزلك وفر الوقت في الأعمال المنزلية والمهام اليومية!',
            ],
        ]);
    }

    public function individualHospitality(): Section
    {
        return $this->get('individual-hospitality', [
            'individual_hospitality_subtitle' => [
                'en' => 'Individual Hospitality',
                'ar' => 'الأعمال الفردية',
            ],
            'individual_hospitality_description' => [
                'en' => 'A premium service for employees of government and corporate entities, combining hotel-style luxury with home comfort. We provide flexible solutions that enhance convenience and eliminate daily household tasks.',
                'ar' => 'خدمة مميزة لموظفي الجهات الحكومية والشركات، تجمع بين فخامة الفنادق وراحة المنزل. نقدم حلولاً مرنة تُعزز راحتكم وتُغنيكم عن المهام المنزلية اليومية.',
            ],
        ]);
    }

    public function whyWe(): Section
    {
        return $this->get('why-we', [
            'why_we_subtitle' => [
                'en' => 'Why We?',
                'ar' => 'لماذا نحن؟',
            ],
            'why_we_description' => [
                'en' => 'We seamlessly blend hospitality with home-like comfort. our motto, "Hotel-style service and more in your home,"reflects our commitment to creating a balanced and hassle-free living experience.',
                'ar' => 'نحن نمزج بسلاسة بين الضيافة والراحة المنزلية. شعارنا "خدمة على طراز الفنادق والمزيد في منزلك" يعكس التزامنا بخلق تجربة معيشية متوازنة وخالية من المتاعب.',
            ],
        ]);
    }

    public function packagePricing(): Section
    {
        return $this->get('package-pricing', [
            'package_pricing_subtitle' => [
                'en' => 'Package Pricing & Payment',
                'ar' => 'تسعير الحزمة والدفع',
            ],
            'package_pricing_description' => [
                'en' => 'Packages are priced monthly with flexible options to suit various budgets. Payment is made directly by the employee.',
                'ar' => 'يتم تسعير الباقات شهريًا مع خيارات مرنة تناسب مختلف الميزانيات. يتم الدفع مباشرةً من قبل الموظف.',
            ],
        ]);
    }

    const MEDIA_COLLECTION_COVER = "who-we-are.cover";

    public function cover()
    {
        return $this->model()->getFirstMedia(self::MEDIA_COLLECTION_COVER);
    }

    public function coverUrl(): string
    {
        $media = $this->model()->getFirstMedia(self::MEDIA_COLLECTION_COVER);
        if ($media) {
            return $media->getUrl();
        }

        $fallback = 'https://placehold.co/400x225.png?text=' . str_replace(' ', '%20', 'Who We Are');
        return $fallback;
    }

    /**
     *  Sets the Cover image
     *
     *  WARN: It clears the previous cover image and set the new one.
     */
    public function setCover($file)
    {
        $this->model()->clearMediaCollection(self::MEDIA_COLLECTION_COVER);

        $this->model()
            ->addMedia($file)
            ->toMediaCollection(self::MEDIA_COLLECTION_COVER);
    }
}
