<?php

namespace App\Support;

class StatisticsPage extends Page
{
    public function key(): string
    {
        return 'statistics';
    }

    public function header(): Section
    {
        return $this->get('header', []);
    }

    public function completedBooking(): Section
    {
        return $this->get('completed_booking', [
            'title' => [
                'en' => 'Completed Booking',
                'ar' => 'الحجوزات المكتملة',
            ],
            'count' => '1250+',
        ]);
    }

    public function happyClients(): Section
    {
        return $this->get('happy_clients', [
            'title' => [
                'en' => 'Happy Clients',
                'ar' => 'العملاء السعداء',
            ],
            'count' => '180+',
        ]);
    }

    public function expertTeam(): Section
    {
        return $this->get('expert_team', [
            'title' => [
                'en' => 'Expert Team',
                'ar' => 'فريق الخبراء',
            ],
            'count' => '85+',
        ]);
    }

    public function awardsWon(): Section
    {
        return $this->get('awards_won', [
            'title' => [
                'en' => 'Awards Won',
                'ar' => 'الجوائز المحصلة',
            ],
            'count' => '158+',
        ]);
    }

    const MEDIA_COLLECTION_COMPLETED_BOOKING_ICON = "statistics.completed-booking-icon";

    public function completedBookingIcon()
    {
        return $this->model()->getFirstMedia(self::MEDIA_COLLECTION_COMPLETED_BOOKING_ICON);
    }

    public function completedBookingIconUrl(): string
    {
        $media = $this->model()->getFirstMedia(self::MEDIA_COLLECTION_COMPLETED_BOOKING_ICON);
        if ($media) {
            return $media->getUrl();
        }

        $fallback = 'https://placehold.co/400x225.png?text=' . str_replace(' ', '%20', 'Completed Booking');
        return $fallback;
    }

    public function setCompletedBookingIcon($file)
    {
        $this->model()->clearMediaCollection(self::MEDIA_COLLECTION_COMPLETED_BOOKING_ICON);

        $this->model()
            ->addMedia($file)
            ->toMediaCollection(self::MEDIA_COLLECTION_COMPLETED_BOOKING_ICON);
    }

    const MEDIA_COLLECTION_HAPPY_CLIENTS_ICON = "statistics.happy-clients-icon";

    public function happyClientsIcon()
    {
        return $this->model()->getFirstMedia(self::MEDIA_COLLECTION_HAPPY_CLIENTS_ICON);
    }

    public function happyClientsIconUrl(): string
    {
        $media = $this->model()->getFirstMedia(self::MEDIA_COLLECTION_HAPPY_CLIENTS_ICON);
        if ($media) {
            return $media->getUrl();
        }

        $fallback = 'https://placehold.co/400x225.png?text=' . str_replace(' ', '%20', 'Happy Clients');
        return $fallback;
    }

    public function setHappyClientsIcon($file)
    {
        $this->model()->clearMediaCollection(self::MEDIA_COLLECTION_HAPPY_CLIENTS_ICON);

        $this->model()
            ->addMedia($file)
            ->toMediaCollection(self::MEDIA_COLLECTION_HAPPY_CLIENTS_ICON);
    }

    const MEDIA_COLLECTION_EXPERT_TEAM_ICON = "statistics.expert-team-icon";

    public function expertTeamIcon()
    {
        return $this->model()->getFirstMedia(self::MEDIA_COLLECTION_EXPERT_TEAM_ICON);
    }

    public function expertTeamIconUrl(): string
    {
        $media = $this->model()->getFirstMedia(self::MEDIA_COLLECTION_EXPERT_TEAM_ICON);
        if ($media) {
            return $media->getUrl();
        }

        $fallback = 'https://placehold.co/400x225.png?text=' . str_replace(' ', '%20', 'Expert Team');
        return $fallback;
    }

    public function setExpertTeamIcon($file)
    {
        $this->model()->clearMediaCollection(self::MEDIA_COLLECTION_EXPERT_TEAM_ICON);

        $this->model()
            ->addMedia($file)
            ->toMediaCollection(self::MEDIA_COLLECTION_EXPERT_TEAM_ICON);
    }

    const MEDIA_COLLECTION_AWARDS_WON_ICON = "statistics.awards-won-icon";

    public function awardsWonIcon()
    {
        return $this->model()->getFirstMedia(self::MEDIA_COLLECTION_AWARDS_WON_ICON);
    }

    public function awardsWonIconUrl(): string
    {
        $media = $this->model()->getFirstMedia(self::MEDIA_COLLECTION_AWARDS_WON_ICON);
        if ($media) {
            return $media->getUrl();
        }

        $fallback = 'https://placehold.co/400x225.png?text=' . str_replace(' ', '%20', 'Awards Won');
        return $fallback;
    }

    public function setAwardsWonIcon($file)
    {
        $this->model()->clearMediaCollection(self::MEDIA_COLLECTION_AWARDS_WON_ICON);

        $this->model()
            ->addMedia($file)
            ->toMediaCollection(self::MEDIA_COLLECTION_AWARDS_WON_ICON);
    }
}
