<?php

namespace App\Support;

class OurServicesPage extends Page
{
    public function key(): string
    {
        return 'our-services';
    }

    public function header(): Section
    {
        return $this->get('header', [
            'title' => [
                'en' => 'What services we offer',
                'ar' => 'ما هي الخدمات التي نقدمها',
            ],
            'description' => [
                'en' => 'Make the most of your time in AlUla—work, relax, and enjoy while we handle the daily chores for you!',
                'ar' => 'استمتع بوقتك في العلا على أكمل وجه، اعمل واسترخ واستمتع بينما نقوم بأعمالك اليومية نيابةً عنك!',
            ],
            'tag' => [
                'en' => 'Our services',
                'ar' => 'خدماتنا',
            ],
            'cover_title' => [
                'en' => 'Our services',
                'ar' => 'خدماتنا',
            ],
            'VAT' => 15,
           // 'discount_rate' => '18'
        ]);
    }

    const MEDIA_COLLECTION_COVER = "our-services.cover";

    public function cover()
    {
        return $this->model()->getFirstMedia(self::MEDIA_COLLECTION_COVER);
    }

    public function coverUrl(): string
    {
        $media = $this->model()->getFirstMedia(self::MEDIA_COLLECTION_COVER);
        if ($media) {
            return $media->getUrl();
        }

        $fallback = 'https://placehold.co/400x225.png?text=' . str_replace(' ', '%20', 'Our Services');
        return $fallback;
    }

    /**
     *  Sets the Cover image
     *
     *  WARN: It clears the previous cover image and set the new one.
     */
    public function setCover($file)
    {
        $this->model()->clearMediaCollection(self::MEDIA_COLLECTION_COVER);

        $this->model()
            ->addMedia($file)
            ->toMediaCollection(self::MEDIA_COLLECTION_COVER);
    }
}
