<?php

namespace App\Support;

class OurPackagesPage extends Page
{
    public function key(): string
    {
        return 'our-packages';
    }

    public function header(): Section
    {
        return $this->get('header', [
            'tag' => [
                'en' => 'Our Packages',
                'ar' => 'باقاتنا',
            ],
            'title' => [
                'en' => 'Lots of Benefits In Our Packages',
                'ar' => 'العديد من المزايا في باقاتنا',
            ],
            'description' => [
                'en' => 'Customize A Package That Suits Your Needs.',
                'ar' => 'قم بتخصيص الحزمة التي تناسب احتياجاتك.',
            ],
        ]);
    }

    const MEDIA_COLLECTION_COVER = "our-packages.cover";

    public function cover()
    {
        return $this->model()->getFirstMedia(self::MEDIA_COLLECTION_COVER);
    }

    public function coverUrl(): string
    {
        $media = $this->model()->getFirstMedia(self::MEDIA_COLLECTION_COVER);
        if ($media) {
            return $media->getUrl();
        }

        $fallback = 'https://placehold.co/400x225.png?text=' . str_replace(' ', '%20', 'Our Packages');
        return $fallback;
    }

    public function setCover($file)
    {
        $this->model()->clearMediaCollection(self::MEDIA_COLLECTION_COVER);

        $this->model()
            ->addMedia($file)
            ->toMediaCollection(self::MEDIA_COLLECTION_COVER);
    }
}
