<?php

namespace App\Support;

class HomePage extends Page
{
    public function key(): string
    {
        return 'home';
    }

    public function header(): Section
    {
        return $this->get('header', [
            'title' => [
                'en' => 'Hotel-style service and more in your home',
                'ar' => 'خدمة على طراز الفنادق وأكثر في منزلك',
            ],
            'description' => [
                'en' => 'Save time on household chores and daily tasks!',
                'ar' => 'وفر الوقت في الأعمال المنزلية والمهام اليومية!',
            ],
        ]);
    }

    const MEDIA_COLLECTION_COVER = "home.cover";

    public function cover()
    {
        return $this->model()->getFirstMedia(self::MEDIA_COLLECTION_COVER);
    }

    public function coverUrl(): string
    {
        $media = $this->model()->getFirstMedia(self::MEDIA_COLLECTION_COVER);
        if ($media) {
            return $media->getUrl();
        }

        $fallback = 'https://placehold.co/400x225.png?text=' . str_replace(' ', '%20', 'Home');
        return $fallback;
    }

    /**
     *  Sets the Cover image
     *
     *  WARN: It clears the previous cover image and set the new one.
     */
    public function setCover($file)
    {
        $this->model()->clearMediaCollection(self::MEDIA_COLLECTION_COVER);

        $this->model()
            ->addMedia($file)
            ->toMediaCollection(self::MEDIA_COLLECTION_COVER);
    }
}
