<?php

namespace App\Support;

class ContactUsPage extends Page
{
    public function key(): string
    {
        return 'contact-us';
    }

    public function header(): Section
    {
        return $this->get('header', [
            'description' => [
                'en' => 'We seamlessly blend hospitality with home-like comfort. our motto, "Hotel-style service and more in your home,"reflects our commitment to creating a balanced and hassle-free living experience.',
                'ar' => 'نحن نمزج بسلاسة بين الضيافة والراحة المنزلية. شعارنا "خدمة على طراز الفنادق والمزيد في منزلك" يعكس التزامنا بخلق تجربة معيشية متوازنة وخالية من المتاعب.',
            ],
            'message' => [
                'en' => 'We will get back to you within 24 hours, or Call us everyday, 09:00AM - 04:00PM',
                'ar' => 'سنتصل بك خلال 24 ساعة، أو اتصل بنا كل يوم من الساعة 9:00 صباحًا حتى 4:00 مساءً',
            ]
        ]);
    }

    public function email(): Section
    {
        return $this->get('email', [
            'subtitle' => [
                'en' => 'For general enquiries:',
                'ar' => 'للاستفسارات العامة:',
            ],
            'description' => 'info@Business Hospitality.com',
        ]);
    }

    public function phone(): Section
    {
        return $this->get('phone', [
            'subtitle' => [
                'en' => 'Contact Number',
                'ar' => 'رقم التواصل',
            ],
            'description' => '+966 55 000 0000',
        ]);
    }

    public function whatsapp(): Section
    {
        return $this->get('whatsapp', [
            'subtitle' => [
                'en' => 'WhatsApp',
                'ar' => 'واتساب',
            ],
            'description' => '+966 55 000 0000',
        ]);
    }

    public function address(): Section
    {
        return $this->get('address', [
            'description' =>  [
                'en' => 'PO Box 0000 Al-Khobar 00000 , Kingdom of Saudi Arabia',
                'ar' => 'ص.ب 0000 الخبر 00000 المملكة العربية السعودية',
            ],
        ]);
    }

    const MEDIA_COLLECTION_COVER = "contact-us.cover";

    public function cover()
    {
        return $this->model()->getFirstMedia(self::MEDIA_COLLECTION_COVER);
    }

    public function coverUrl(): string
    {
        $media = $this->model()->getFirstMedia(self::MEDIA_COLLECTION_COVER);
        if ($media) {
            return $media->getUrl();
        }

        $fallback = 'https://placehold.co/400x225.png?text=' . str_replace(' ', '%20', 'Cover');
        return $fallback;
    }

    public function setCover($file)
    {

        $this->model()->clearMediaCollection(self::MEDIA_COLLECTION_COVER);

        $this->model()
            ->addMedia($file)
            ->toMediaCollection(self::MEDIA_COLLECTION_COVER);
    }

    const MEDIA_COLLECTION_LOGO = "contact-us.logo";

    public function logo()
    {
        return $this->model()->getFirstMedia(self::MEDIA_COLLECTION_LOGO);
    }

    public function logoUrl(): string
    {
        $media = $this->model()->getFirstMedia(self::MEDIA_COLLECTION_LOGO);
        if ($media) {
            return $media->getUrl();
        }

        $fallback = 'https://placehold.co/400x225.png?text=' . str_replace(' ', '%20', 'Logo');
        return $fallback;
    }

    public function setLogo($file)
    {

        $this->model()->clearMediaCollection(self::MEDIA_COLLECTION_LOGO);

        $this->model()
            ->addMedia($file)
            ->toMediaCollection(self::MEDIA_COLLECTION_LOGO);
    }

    const MEDIA_COLLECTION_EMAIL_ICON = "contact-us.email-icon";

    public function emailIcon()
    {
        return $this->model()->getFirstMedia(self::MEDIA_COLLECTION_EMAIL_ICON);
    }

    public function emailIconUrl(): string
    {
        $media = $this->model()->getFirstMedia(self::MEDIA_COLLECTION_EMAIL_ICON);
        if ($media) {
            return $media->getUrl();
        }

        $fallback = 'https://placehold.co/400x225.png?text=' . str_replace(' ', '%20', 'Email');
        return $fallback;
    }


    public function setEmailIcon($file)
    {
        $this->model()->clearMediaCollection(self::MEDIA_COLLECTION_EMAIL_ICON);

        $this->model()
            ->addMedia($file)
            ->toMediaCollection(self::MEDIA_COLLECTION_EMAIL_ICON);
    }
    const MEDIA_COLLECTION_PHONE_ICON = "contact-us.phone-icon";

    public function phoneIcon()
    {
        return $this->model()->getFirstMedia(self::MEDIA_COLLECTION_PHONE_ICON);
    }

    public function phoneIconUrl(): string
    {
        $media = $this->model()->getFirstMedia(self::MEDIA_COLLECTION_PHONE_ICON);
        if ($media) {
            return $media->getUrl();
        }

        $fallback = 'https://placehold.co/400x225.png?text=' . str_replace(' ', '%20', 'Phone');
        return $fallback;
    }

    public function setPhoneIcon($file)
    {
        $this->model()->clearMediaCollection(self::MEDIA_COLLECTION_PHONE_ICON);

        $this->model()
            ->addMedia($file)
            ->toMediaCollection(self::MEDIA_COLLECTION_PHONE_ICON);
    }
    const MEDIA_COLLECTION_WHATSAPP_ICON = "contact-us.whatsapp-icon";

    public function whatsappIcon()
    {
        return $this->model()->getFirstMedia(self::MEDIA_COLLECTION_WHATSAPP_ICON);
    }

    public function whatsappIconUrl(): string
    {
        $media = $this->model()->getFirstMedia(self::MEDIA_COLLECTION_WHATSAPP_ICON);
        if ($media) {
            return $media->getUrl();
        }

        $fallback = 'https://placehold.co/400x225.png?text=' . str_replace(' ', '%20', 'Whatsapp');
        return $fallback;
    }


    public function setWhatsappIcon($file)
    {
        $this->model()->clearMediaCollection(self::MEDIA_COLLECTION_WHATSAPP_ICON);

        $this->model()
            ->addMedia($file)
            ->toMediaCollection(self::MEDIA_COLLECTION_WHATSAPP_ICON);
    }

    const MEDIA_COLLECTION_ADDRESS_ICON = "contact-us.address-icon";

    public function addressIcon()
    {
        return $this->model()->getFirstMedia(self::MEDIA_COLLECTION_ADDRESS_ICON);
    }

    public function addressIconUrl(): string
    {
        $media = $this->model()->getFirstMedia(self::MEDIA_COLLECTION_ADDRESS_ICON);
        if ($media) {
            return $media->getUrl();
        }

        $fallback = 'https://placehold.co/400x225.png?text=' . str_replace(' ', '%20', 'Address');
        return $fallback;
    }


    public function setAddressIcon($file)
    {
        $this->model()->clearMediaCollection(self::MEDIA_COLLECTION_ADDRESS_ICON);

        $this->model()
            ->addMedia($file)
            ->toMediaCollection(self::MEDIA_COLLECTION_ADDRESS_ICON);
    }
}
