<?php
namespace App\Services;

use Illuminate\Mail\Mailable;
use Illuminate\Support\Facades\Mail;

class EmailService
{
    public function send(string $senderKey, string|array $to, Mailable $mailable): void
    {
        $profile = config("mail_senders.$senderKey");

        if (!$profile) {
            throw new \Exception("Sender profile [$senderKey] not found.");
        }

        $mailable->from($profile['email'], $profile['name']);

        Mail::to($to)->send($mailable);
    }
}
