<?php

namespace App\Rules;

use Illuminate\Contracts\Validation\Rule;
use Illuminate\Support\Str;

class MaxPlainTextLength implements Rule
{
    protected int $limit;

    public function __construct(int $limit)
    {
        $this->limit = $limit;
    }

    public function passes($attribute, $value): bool
    {
        if (!is_string($value)) {
            return false;
        }

        $plain = strip_tags($value);
        return Str::length($plain) <= $this->limit;
    }

    public function message(): string
    {
        return __('validation.plain_text_max', [
            'limit' => $this->limit,
        ]);
    }
}
