<?php

namespace App\Providers;

use Illuminate\Support\Facades\Gate;
use Laravel\Horizon\HorizonApplicationServiceProvider;
use App\Enums\Role;
use App\Models\User;

class HorizonServiceProvider extends HorizonApplicationServiceProvider
{
    public function boot(): void
    {
        parent::boot();

        //  TODO: Add contact information for Horizon notifications
        // Horizon::routeSmsNotificationsTo('15556667777');
        // Horizon::routeMailNotificationsTo('example@example.com');
        // Horizon::routeSlackNotificationsTo('slack-webhook-url', '#channel');
    }

    protected function gate(): void
    {
        //   Gate::define('viewHorizon', fn($user) => $user->isAdmin);
        Gate::define('viewHorizon', function (?User $user): bool {
            if (app()->environment('local', 'testing')) {
                return true;
            }

            return $user?->hasRole(Role::admin->value) ?? false;
        });
    }
}
