<?php

namespace App\Providers\Filament;

use Filament\Http\Middleware\Authenticate;
use Filament\Http\Middleware\AuthenticateSession;
use Filament\Http\Middleware\DisableBladeIconComponents;
use Filament\Http\Middleware\DispatchServingFilamentEvent;
use Filament\Navigation\NavigationItem;
use Filament\Pages;
use Filament\Panel;
use Filament\PanelProvider;
use Filament\Support\Colors\Color;
use Filament\Widgets;
use Illuminate\Cookie\Middleware\AddQueuedCookiesToResponse;
use Illuminate\Cookie\Middleware\EncryptCookies;
use Illuminate\Foundation\Http\Middleware\VerifyCsrfToken;
use Illuminate\Routing\Middleware\SubstituteBindings;
use Illuminate\Session\Middleware\StartSession;
use Illuminate\Support\Facades\Auth;
use Illuminate\View\Middleware\ShareErrorsFromSession;
use Outerweb\FilamentTranslatableFields\Filament\Plugins\FilamentTranslatableFieldsPlugin;

class AdminPanelProvider extends PanelProvider
{
    public function panel(Panel $panel): Panel
    {
        return $panel
            ->default()
            ->id("admin")
            ->path("admin")
            ->login()
            ->brandLogo(asset("logo.svg"))
            ->pages([
                \App\Filament\Pages\Home::class,
                \App\Filament\Pages\WhoWeAre::class,
                \App\Filament\Pages\OurServicesPage::class,
                \App\Filament\Pages\YourPackage::class,
                \App\Filament\Pages\OurPackages::class,
                \App\Filament\Pages\ContactUs::class,
                \App\Filament\Pages\Newsletter::class,
                \App\Filament\Pages\Statistics::class,
                \App\Filament\Pages\PrivacyPolicy::class,
                \App\Filament\Pages\TermsAndConditions::class,
                \App\Filament\Pages\SendNewsletter::class,
                \App\Filament\Pages\Socials::class,
            ])
            /*  ->discoverPages(
                in: app_path("Filament/Pages"),
                for: "App\\Filament\\Pages"
            )*/
            ->colors([
                "primary" => Color::Amber,
            ])
            ->resources([
                \App\Filament\Resources\AdminUserResource::class,
                \App\Filament\Resources\OurServiceResource::class,
                \App\Filament\Resources\PackageTypeResource::class,
                \App\Filament\Resources\PackageResource::class,
                \App\Filament\Resources\ServiceRequestResource::class,
                \App\Filament\Resources\PackageRequestResource::class,
                \App\Filament\Resources\ContactMessageResource::class,
                \App\Filament\Resources\NewsletterSubscriberResource::class,
            ])
            /* ->discoverResources(
                in: app_path("Filament/Resources"),
                for: "App\\Filament\\Resources"
            )*/
            /*->discoverPages(
                in: app_path("Filament/Pages"),
                for: "App\\Filament\\Pages"
            )*/
            ->pages([
                \App\Filament\Pages\Dashboard::class, 
            ])
            //  ->pages([Pages\Dashboard::class])
            ->discoverWidgets(
                in: app_path("Filament/Widgets"),
                for: "App\\Filament\\Widgets"
            )
            ->widgets([
                Widgets\AccountWidget::class,
                //   Widgets\FilamentInfoWidget::class,
            ])
            ->middleware([
                EncryptCookies::class,
                AddQueuedCookiesToResponse::class,
                StartSession::class,
                AuthenticateSession::class,
                ShareErrorsFromSession::class,
                VerifyCsrfToken::class,
                SubstituteBindings::class,
                DisableBladeIconComponents::class,
                DispatchServingFilamentEvent::class,
            ])
            ->authMiddleware([Authenticate::class])
            ->navigationItems([
                NavigationItem::make("telescope")
                    ->label(fn(): string => __("navigation.telescope"))
                    ->badge(fn(): string => "●")
                    ->badgeTooltip(
                        fn(): string => __("navigation.telescope-tooltip")
                    )
                    ->url(
                        fn(): string => route("telescope"),
                        shouldOpenInNewTab: true
                    )
                    ->icon("heroicon-o-chart-bar-square")
                    ->group(fn(): string => __("navigation.monitor"))
                    ->visible(
                        fn(): bool => !app()->environment("testing") &&
                            auth()->user()?->hasRole(\App\Enums\Role::admin->value)
                      //  Auth::user()->isAdmin
                    ),

                NavigationItem::make("pulse")
                    ->label(fn(): string => __("navigation.pulse"))
                    ->badge(fn(): string => "●")
                    ->badgeTooltip(
                        fn(): string => __("navigation.pulse-tooltip")
                    )
                    ->url(
                        fn(): string => route("pulse"),
                        shouldOpenInNewTab: true
                    )
                    ->icon("heroicon-o-heart")
                    ->group(fn(): string => __("navigation.monitor"))
                    ->visible(
                        fn(): bool => !app()->environment("testing") &&
                            auth()->user()?->hasRole(\App\Enums\Role::admin->value)
                        //  Auth::user()->isAdmin
                    ),

                NavigationItem::make("horizon")
                    ->label(fn(): string => __("navigation.horizon"))
                    ->badge(fn(): string => "●")
                    ->badgeTooltip(
                        fn(): string => __("navigation.horizon-tooltip")
                    )
                    ->url(
                        fn(): string => route("horizon.index"),
                        shouldOpenInNewTab: true
                    )
                    ->icon("heroicon-o-lifebuoy")
                    ->group(fn(): string => __("navigation.monitor"))
                    ->visible(
                        fn(): bool => !app()->environment("testing") &&
                            auth()->user()?->hasRole(\App\Enums\Role::admin->value)
                       // Auth::user()->isAdmin
                    ),
            ])
            ->plugins([
                FilamentTranslatableFieldsPlugin::make()->supportedLocales(
                    collect(config("app.supported_locales"))
                        ->mapWithKeys(
                            fn($locale) => [$locale => strtoupper($locale)]
                        )
                        ->toArray()
                ),
            ]);
    }
}
