<?php

namespace App\Providers;

use App\Contracts\ResponseBuilder;
use App\Http\Response\JsonResponseBuilder;
use App\Models\OurService;
use App\Models\User;
use Illuminate\Support\Facades\Gate;
use Illuminate\Support\ServiceProvider;
use Laravel\Pulse\Facades\Pulse;
use BezhanSalleh\FilamentLanguageSwitch\LanguageSwitch;
use Illuminate\Database\Eloquent\Relations\Relation;
use App\Models\Package;

class AppServiceProvider extends ServiceProvider
{
    public function register(): void
    {
        $this->app->bind(ResponseBuilder::class, JsonResponseBuilder::class);

        $this->app->bind(\App\Contracts\AuthProvider::class, function ($app) {
            $provider = request()->route("provider");
            switch ($provider) {
                case "github":
                    return $app->make(
                        \App\Services\AuthProviders\GithubAuthProvider::class
                    );
                default:
                    throw new \Exception("Invalid provider");
            }

            throw new \Exception("Invalid provider");
        });
    }

    public function boot(): void
    {
        Gate::define("viewPulsew", fn(User $user) => $user->isAdmin);

        Pulse::user(
            fn($user) => [
                "name" => $user->name,
                "extra" => $user->email,
                "avatar" => $user->avatar,
            ]
        );

        LanguageSwitch::configureUsing(function (LanguageSwitch $switch) {
            $switch->locales(config("app.supported_locales"));
        });
    }
}
