<?php
namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Spatie\MediaLibrary\HasMedia;
use Spatie\MediaLibrary\InteractsWithMedia;

class SitePage extends Model implements HasMedia
{
    use HasFactory, InteractsWithMedia;

    protected $fillable = ["key", "content"];

    protected function casts(): array
    {
        return [
            "key" => "string",
            "id" => "integer",
            "content" => "array",
        ];
    }
}
