<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Request extends Model
{
    use HasFactory;

    protected $fillable = [
        "name",
        "email",
        "phone_number",
        "type",
        "type_id",
        "date",
        "time",
        "message"
    ];

    public function requestable()
    {
        return $this->morphTo(__FUNCTION__, 'type', 'type_id')->withTrashed();
    }
}
