<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Spatie\Translatable\HasTranslations;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Spatie\MediaLibrary\HasMedia;
use Spatie\MediaLibrary\InteractsWithMedia;
use Illuminate\Database\Eloquent\SoftDeletes;

class Package extends Model implements HasMedia
{
    use HasFactory, HasTranslations, InteractsWithMedia, SoftDeletes;

    protected $fillable = [
        "title",
        "package_type_id",
        "validity",
        "validity_type",
        "price",
        "discount_rate",
        "extra_discount_rate"
    ];

    public $translatable = ["title"];

    public const MEDIA_COLLECTION_IMAGE = "package_image";

    public function registerMediaCollections(): void
    {
        $this->addMediaCollection(self::MEDIA_COLLECTION_IMAGE)
            ->singleFile()
            ->useDisk('public')
            ->useFallbackUrl("https://placehold.co/400x225.png?text=" . str_replace(" ", "%20", $this->title));
    }

    public function packageType()
    {
        return $this->belongsTo(PackageType::class);
    }

    public function services()
    {
        return $this->belongsToMany(OurService::class, 'package_services')->withTimestamps()->withPivot('status', 'count');
    }


    public function packageServices()
    {
        return $this->hasMany(PackageService::class);
    }

    public function requests()
    {
        return $this->morphMany(Request::class, 'requestable', 'type', 'type_id');
    }
}
