<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Spatie\MediaLibrary\HasMedia;
use Spatie\MediaLibrary\InteractsWithMedia;
use Spatie\Translatable\HasTranslations;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\SoftDeletes;

class OurService extends Model implements HasMedia
{
    use HasFactory, HasTranslations, InteractsWithMedia, SoftDeletes;

    protected $fillable = [
        "title",
        "description",
        "unit",
        "price",
        "sort"
    ];

    protected static function booted()
    {
        static::creating(function ($model) {
            $maxSort = self::max('sort') ?? 0;
            $model->sort = $maxSort + 1;
        });
    }

    public $translatable = ["title", "description", "unit"];

    public const MEDIA_COLLECTION_IMAGE = "image";

    public function registerMediaCollections(): void
    {
        $this->addMediaCollection(self::MEDIA_COLLECTION_IMAGE)
            ->singleFile()
            ->useDisk('public')
            ->useFallbackUrl("https://placehold.co/400x225.png?text=" . str_replace(" ", "%20", $this->title));
    }

    public function packages()
    {
        return $this->belongsToMany(Package::class, 'package_services')->withTimestamps()->withPivot('status');
    }

    public function requests()
    {
        return $this->morphMany(Request::class, 'requestable', 'type', 'type_id');
    }
}
