<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class NewsletterSubscriber extends Model
{
    use HasFactory;

    protected $fillable = ['email'];

    /**
     * Determine if the given email is already subscribed.
     */
    public static function isSubscribed(string $email): bool
    {
        return self::where('email', $email)->exists();
    }
}
