<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class WhoWeAreResource extends JsonResource
{
    public function toArray(Request $request): array
    {
        $contactUs = \App\Support\ContactUsPage::make();

        return [
            'type' => 'who-we-are-page',
            'id' => $this->key(),
            'attributes' => [
                'header' => [
                    'cover' => $this->coverUrl(),
                    'title' => $this->header()->get('title'),
                    'description' => $this->header()->get('description'),
                ],
                'individualHospitality' => [
                    'title' => $this->individualHospitality()->get('individual_hospitality_subtitle'),
                    'description' => $this->individualHospitality()->get('individual_hospitality_description'),
                ],
                'whyWe' => [
                    'title' => $this->whyWe()->get('why_we_subtitle'),
                    'description' => $this->whyWe()->get('why_we_description'),
                ],
                'packagePricing' => [
                    'title' => $this->packagePricing()->get('package_pricing_subtitle'),
                    'description' => $this->packagePricing()->get('package_pricing_description'),
                ],
                'contact' => [
                    'phone_number' => $contactUs->phone()->get('description'),
                ],
            ],
            'links' => (object) [],
            'relationships' => (object) [],
            'includes' => (object) [],
        ];
    }
}
