<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class StatisticsResource extends JsonResource
{
    public function toArray(Request $request): array
    {
        return [
            'type' => 'statistics',
            'id' => $this->key(),
            'attributes' => [
                'completed_booking' => [
                    'icon' => $this->completedBookingIconUrl(),
                    'title' => $this->completedBooking()->get('title'),
                    'count' => $this->completedBooking()->get('count'),
                ],
                'happy_clients' => [
                    'icon' => $this->happyClientsIconUrl(),
                    'title' => $this->happyClients()->get('title'),
                    'count' => $this->happyClients()->get('count'),
                ],
                'expert_team' => [
                    'icon' => $this->expertTeamIconUrl(),
                    'title' => $this->expertTeam()->get('title'),
                    'count' => $this->expertTeam()->get('count'),
                ],
                'awards_won' => [
                    'icon' => $this->awardsWonIconUrl(),
                    'title' => $this->awardsWon()->get('title'),
                    'count' => $this->awardsWon()->get('count'),
                ],
            ],
            'links' => (object) [],
            'relationships' => (object) [],
            'includes' => (object) [],
        ];
    }
}
