<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class PackagesResource extends JsonResource
{
    public function toArray(Request $request): array
    {
        /*  if ($this->price_before > $this->price_after)
            $availableOffer = 1;
        else*/
        $availableOffer = 0;
        $data = [
            'id' => $this->id,
            'type' => 'packages',
            'attributes' => [
                'title' => $this->title,
                'package_type' => $this->packageType->title,
                'validity' => $this->validity,
                'validity_type' => $this->validity_type,
                'available_offer' => $availableOffer,
                'price' => $this->price . " " . __('app.sar'),
                'image' => $this->getFirstMediaUrl(\App\Models\Package::MEDIA_COLLECTION_IMAGE),
                'number_of_services' => $this->services()->count(),
                'services' => $this->services()->pluck('title'),
            ],
            'relationships' => (object) [],
            'links' => (object) [],
        ];
        /*   if ($availableOffer == 1) {
            $data['attributes']['price_before'] = $this->price_before . " " . __('app.sar');
            $data['attributes']['price_after'] = $this->price_after . " " . __('app.sar');
        } else {
            $data['attributes']['price'] = $this->price_after . " " . __('app.sar');
        }*/
        return $data;
    }
}
