<?php

namespace App\Http\Resources;


use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class PackageDetailsResource extends JsonResource
{
    public function toArray(Request $request): array
    {
        $locale = app()->getLocale();

        $config  = \App\Support\OurServicesPage::make();
        $vatPct  = (float) ($config->header()->get('VAT') ?? 0);
        $price   = (float) $this->price;
        $extraPct = (float) ($this->extra_discount_rate ?? 0);

        $vatAmount       = $price * $vatPct / 100;
        $priceWithVat    = $price + $vatAmount;
        $priceAfterExtra = $price - ($price * $extraPct / 100); // price after applying extra discount
        $priceAfterExtra = $priceAfterExtra + ($priceAfterExtra * $vatPct / 100); // price after applying VAT on the discounted price

        $totalPriceBeforeDiscount = 0;

        $services = $this->services->map(function ($service) use ($locale, &$totalPriceBeforeDiscount) {
            $pivot = $service->pivot;
            $count = (int) ($pivot->count ?? 0);
            $unit  = (float) $service->price;
            $total = $unit * $count;

            $totalPriceBeforeDiscount += $total; 

            return [
                'id'          => $service->id,
                'title'       => $service->getTranslation('title', $locale),
                'unit'        => $service->getTranslation('unit', $locale),
                'unit_price'  => $unit,
                'count'       => $count,
                'total_price' => $total,
            ];
        });

        $data = [
            'id'                          => $this->id,
            'title'                       => $this->getTranslation('title', $locale),
            'package_type'                => $this->packageType?->title,
            'validity'                    => $this->validity,
            'validity_type'               => $this->validity_type,
            'total_price_before_discount' => $totalPriceBeforeDiscount, // accumulate total services price before discount (service price * count)
            'total_services'              => $this->services()->count(),
            'vat'                         => $vatAmount, // VAT amount based on the package price
            'discount_rate'               => ($this->discount_rate ?? 0) . '%',
            'price_with_vat'              => $priceWithVat, // package price after applying VAT
            'vat_percentage'              => $vatPct . '%',
           // 'extra_percentage'            => $extraPct . '%',
            'final_package_price'         => $price, // package price
            'price_after_extra'           => $priceAfterExtra, // package price after applying extra discount and VAT
            'image'                       => $this->getFirstMediaUrl(\App\Models\Package::MEDIA_COLLECTION_IMAGE),
            'services'                    => $services,
        ];

        if($extraPct !=0 && $this->extra_discount_rate != null){
            $data['extra_percentage'] = $extraPct . '%';
        }

        return $data;
    }
}
