<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class OurServicesResource extends JsonResource
{
    public function toArray(Request $request): array
    {
        static $count = 0;
        return [
            'id' => $this->id,
            'type' => 'our-services',
            'attributes' => [
                'count' => str_pad(++$count, 2, '0', STR_PAD_LEFT),
                'title' => $this->title,
                'description' => $this->description,
                'unit' => $this->unit,
                'price' => $this->price. " ".__('app.sar'),
                'image' => $this->getFirstMediaUrl(\App\Models\OurService::MEDIA_COLLECTION_IMAGE),
            ],
            'relationships' => (object) [],
            'links' => (object) [],
        ];
    }
}
