<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class OurServicesPageResource extends JsonResource
{
    public function toArray(Request $request): array
    {

        return [
            'type' => 'our-services-page',
            'id' => $this->key(),
            'attributes' => [
                'header' => [
                    'cover' => $this->coverUrl(),
                    'title' => $this->header()->get('title'),
                    'description' => $this->header()->get('description'),
                    'tag' => $this->header()->get('tag'),
                    'cover_title' => $this->header()->get('cover_title'),
                ]
            ],
            'links' => (object) [],
            'relationships' => (object) [],
            'includes' => (object) [],
        ];
    }
}
