<?php

namespace App\Http\Resources;


use App\Models\OurService;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class OurServiceDetailsResource extends JsonResource
{
    public function toArray(Request $request): array
    {
        $vat = \App\Support\OurServicesPage::make();
        return [
            'id' => $this->id,
            'title' => $this->title,
            'description' => $this->description,
            'unit' => $this->unit,
            'price' => $this->price . " " . __('app.sar'),
            'image' => $this->getFirstMediaUrl(\App\Models\OurService::MEDIA_COLLECTION_IMAGE),
        ];
    }
}
