<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class OurPackagesResource extends JsonResource
{
    public function toArray(Request $request): array
    {
        return [
            'type' => 'our-packages-page',
            'id' => $this->key(),
            'attributes' => [
                'header' => [
                    'cover' => $this->coverUrl(),
                    'title' => $this->header()->get('title'),
                    'description' => $this->header()->get('description'),
                    'tag' => $this->header()->get('tag'),
                ]
            ],
            'links' => (object) [],
            'relationships' => (object) [],
            'includes' => (object) [],
        ];
    }
}
