<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class NewsletterResource extends JsonResource
{
    public function toArray(Request $request): array
    {
        return [
            'type' => 'newsletter',
            'id' => $this->key(),
            'attributes' => [
                'header' => [
                    'title' => $this->header()->get('title'),
                    'description' => $this->header()->get('description'),
                ],
            ],
            'links' => (object) [],
            'relationships' => (object) [],
            'includes' => (object) [],
        ];
    }
}
