<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class HomePageResource extends JsonResource
{
    public function toArray(Request $request): array
    {
           $contactUs = \App\Support\ContactUsPage::make();
        return [
            'type' => 'home-page',
            'id' => $this->key(),
            'attributes' => [
                'header' => [
                    'cover' => $this->coverUrl(),
                    'title' => $this->header()->get('title'),
                    'description' => $this->header()->get('description'),
                    'logo' => $contactUs->logoUrl(),
                ],
            ],
            'links' => (object) [],
            'relationships' => (object) [],
            'includes' => (object) [],
        ];
    }
}
