<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class ContactUsResource extends JsonResource
{
    public function toArray(Request $request): array
    {
        return [
            'type' => 'contact-us-page',
            'id' => $this->key(),
            'attributes' => [
                'header' => [
                    'cover' => $this->coverUrl(),
                    'logo' => $this->logoUrl(),
                    'description' => $this->header()->get('description'),
                    'message' => $this->header()->get('message'),
                ],
                'email' => [
                    'icon' => $this->emailIconUrl(),
                    'subtitle' => $this->email()->get('subtitle'),
                    'description' => $this->email()->get('description'),
                ],
                'phone' => [
                    'icon' => $this->phoneIconUrl(),
                    'subtitle' => $this->phone()->get('subtitle'),
                    'description' => $this->phone()->get('description'),
                ],
                'whatsapp' => [
                    'icon' => $this->whatsappIconUrl(),
                    'subtitle' => $this->whatsapp()->get('subtitle'),
                    'description' => $this->whatsapp()->get('description'),
                ],
                'address' => [
                    'icon' => $this->addressIconUrl(),
                    'description' => $this->address()->get('description'),
                ],
            ],
            'links' => (object) [],
            'relationships' => (object) [],
            'includes' => (object) [],
        ];
    }
}
