<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class ContactMessageResource extends JsonResource
{
    public function toArray(Request $request): array
    {
 
        return [
            'id' => (string) $this->id,
            'type' => 'contact-message',
            'attributes' => [
                'name' => $this->name,
                'email' => $this->email,
                'message' => $this->message,
                'createdAt' => $this->created_at->toIso8601String(),
                'updatedAt' => $this->updated_at->toIso8601String(),
            ],
            'links' => (object) [],
            'relationships' => (object) [],
        ];
    }
}
