<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;
use Illuminate\Support\Str;

class AuthProviderRedirectResource extends JsonResource
{
    public function toArray(Request $request): array
    {
        return [
            'type' => 'auth-provider-redirect',
            'id' => Str::uuid(),
            'attributes' => [
                'redirectUrl' => $this->redirectUrl,
            ],
            'links' => (object) [],
            'relationships' => (object) [],
        ];
    }
}
