<?php

namespace App\Http\Requests;


class StoreContactMessageRequest extends BaseFormRequest
{
    public function rules(): array
    {

        return [
            'name' => 'required|string',
            'email' => 'required|email',
            'phone_number' => 'required|string',
            'subject' => 'required|string',
            'message' => 'required|string',
        ];
        /* return [
            'data.attributes.name' => 'required|string',
            'data.attributes.email' => 'required|email',
            'data.attributes.phone_number' => 'required|string',
            'data.attributes.subject' => 'required|string',
            'data.attributes.message' => 'required|string',
        ];*/
    }

    public function mappedAttributes(): array
    {
        return $this->mapped([
            'name' => 'name',
            'email' => 'email',
            'phone_number' => 'phone_number',
            'subject' => 'subject',
            'message' => 'message',
        ]);

        /* return $this->mapped([
            'data.attributes.name' => 'name',
            'data.attributes.email' => 'email',
            'data.attributes.phone_number' => 'phone_number',
            'data.attributes.subject' => 'subject',
            'data.attributes.message' => 'message',
        ]);*/
    }
}
