<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class NewsletterSubscriberStoreRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            "email" => ["required", "email", "max:255"],
        ];
    }

    /**
     * Get the validated email address from the request.
     */
    public function email(): string
    {
        return data_get($this->validated(), "email");
    }
}
