<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\SocialLink;
use App\Http\Resources\SocialLinkResource;
use Illuminate\Support\Facades\Mail;

class SocialsController extends Controller
{
    public function index()
    {
        return SocialLinkResource::collection(SocialLink::all());
    }

    public function testEmail()
    {
        $to = 'rawan1994massri@gmail.com';
        $subject = 'Test Email';
        $message = 'This is a static test email sent from Laravel API.';

        $fromAddress = 'Info@vendor.alsarhindvhospitality.com';
        $fromName = 'Individual Hospitality';


        try {
            Mail::raw($message, function ($msg) use ($to, $subject, $fromAddress, $fromName) {
                $msg->to($to)
                    ->from($fromAddress, $fromName)
                    ->subject($subject);
            });

            return response()->json([
                'ok' => true,
                'message' => "Test email sent to {$to}",
            ]);
        } catch (\Exception $e) {
            return response()->json([
                'ok' => false,
                'error' => $e->getMessage(),
            ], 500);
        }
    }
}
