<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Http\Resources\PackagesResource;
use App\Http\Resources\PackageDetailsResource;
use App\Models\Package;
use Illuminate\Http\Request;

class PackagesController extends Controller
{
    public function index(Request $request)
    {
        return PackagesResource::collection(Package::where("package_type_id", $request->type_id)->get());
    }

    public function show(Request $request)
    {
        $package = Package::with(['services', 'packageServices'])->findOrFail($request->id);
        return PackageDetailsResource::make($package);
    }
}
