<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Http\Resources\OurServicesResource;
use App\Models\OurService;
use Illuminate\Http\Request;
use App\Http\Resources\OurServiceDetailsResource;

class OurServicesController extends Controller
{
    public function index()
    {
        return OurServicesResource::collection(OurService::all());
    }

        public function show(Request $request)
    {
        $service = OurService::findOrFail($request->id);
        return OurServiceDetailsResource::make($service);
    }
}
