<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\NewsletterSubscriber;
use App\Http\Resources\NewsletterSubscriberResource;
use Illuminate\Http\JsonResponse;
use App\Http\Requests\NewsletterSubscriberStoreRequest;

class NewsletterSubscribersController extends Controller
{
    /**
     * Store a new newsletter subscription.
     */
    public function store(NewsletterSubscriberStoreRequest $request): JsonResponse
    {
        $email = data_get($request->validated(), 'email');
        $subscriber = NewsletterSubscriber::firstOrCreate([
            "email" => $email,
        ]);

        return (new NewsletterSubscriberResource($subscriber))
            ->response()
            ->setStatusCode(201);
    }
}
