<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Http\Requests\StoreContactMessageRequest;
use App\Http\Resources\ContactMessageResource;
use App\Mail\ContactMessageNotification;
use App\Mail\InternalContactMessageNotification;
use App\Models\ContactMessage;
use App\Models\Setting;
use Carbon\Carbon;
use Illuminate\Support\Facades\Mail;
use App\Services\EmailService;

class ContactMessageController extends Controller
{
    public function store(StoreContactMessageRequest $request)
    {
        /*  Mail::raw('This is a static test email body.', function ($message) {
            $message->to("rawan1994massri@gmail.com")
                ->subject('Static Test Email');
        });
        dd("//");*/
        /* Mail::raw('Test ' . 'https://dashboard.individual-hospitality.digisolapps.com/admin/contact-messages', fn($m)=>$m->to('rawan1994massri@gmail.com')->subject('Link Test'));
        dd("//");*/
        $message = ContactMessage::create($request->mappedAttributes());

        $clientEmail = config("mail_senders.contact_client");
        $infoEmail = config("mail_senders.contact_info");

        $emailData = [
            'name' => $request->name,
            'email' => $request->email,
            'phone_number' => $request->phone_number,
            'subject' => $request->subject,
            'msg' => $request->message,
            'date' => $message->created_at ? Carbon::parse($message->created_at)->format('F j, Y h:i A') : null,
        ];

        try {
            Mail::to($infoEmail['to_email'])->send( 
                tap(new InternalContactMessageNotification($emailData), function ($m) use ($infoEmail) {
                    $m->from($infoEmail['from_email'], $infoEmail['name']);
                })
            );

            Mail::to($request->email)->send(tap(new ContactMessageNotification($request->name), function ($m) use ($clientEmail) {
                $m->from($clientEmail['from_email'], $clientEmail['name']);
            }));
        } catch (\Exception $e) {
            \Log::error('Mail failed: ' . $e->getMessage());
        }
        return ContactMessageResource::make($message);
    }
}
