<?php

namespace App\Filament\Resources;

use App\Filament\Resources\NewsletterSubscriberResource\Pages;
use App\Models\NewsletterSubscriber;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;
use App\Enums\Role;

class NewsletterSubscriberResource extends Resource
{
    protected static ?string $model = NewsletterSubscriber::class;

    protected static ?string $navigationIcon = "heroicon-o-envelope";

    public static function canViewAny(): bool
    {
        return auth()->user()?->hasRole(Role::admin->value) ?? false;
    }
    public static function canCreate(): bool
    {
        return auth()->user()?->hasRole(Role::admin->value) ?? false;
    }
    public static function canEdit($record): bool
    {
        return auth()->user()?->hasRole(Role::admin->value) ?? false;
    }
    public static function canDelete($record): bool
    {
        return auth()->user()?->hasRole(Role::admin->value) ?? false;
    }

    public static function getNavigationLabel(): string
    {
        return __("newsletter-subscribers-resource.newsletter-subscribers");
    }

    public static function getPluralModelLabel(): string
    {
        return __("newsletter-subscribers-resource.newsletter-subscribers");
    }

    public function getTitle(): string|\Illuminate\Contracts\Support\Htmlable
    {
        return __("newsletter-subscribers-resource.newsletter-subscribers");
    }

    public static function form(Form $form): Form
    {
        return $form->schema([
            Forms\Components\TextInput::make("email")
                ->label(__("newsletter-subscribers-resource.email-label"))
                ->placeholder(
                    __("newsletter-subscribers-resource.email-placeholder")
                )
                ->email()
                ->required()
                ->unique(ignoreRecord: true)
                ->maxLength(255),
        ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->columns([
                Tables\Columns\TextColumn::make("email")
                    ->label(__("newsletter-subscribers-resource.email-label"))
                    ->searchable()
                    ->sortable(),

                Tables\Columns\TextColumn::make("created_at")
                    ->label(
                        __(
                            "newsletter-subscribers-resource.subscribed-at-label"
                        )
                    )
                    ->dateTime('M d, Y h:i A')
                    ->sortable(),
            ])
            ->filters([
                //
            ])
            ->actions([Tables\Actions\EditAction::make()])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DeleteBulkAction::make(),
                ]),
            ]);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            "index" => Pages\ListNewsletterSubscribers::route("/"),
            "create" => Pages\CreateNewsletterSubscriber::route("/create"),
            "edit" => Pages\EditNewsletterSubscriber::route("/{record}/edit"),
        ];
    }
}
