<?php

namespace App\Filament\Resources;

use App\Filament\Resources\ContactMessageResource\Pages;
use App\Models\ContactMessage;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;
use App\Enums\Role;

class ContactMessageResource extends Resource
{
    protected static ?string $model = ContactMessage::class;

    protected static ?string $navigationIcon = "heroicon-o-inbox-arrow-down";
    
        public static function canViewAny(): bool
    {
        return auth()->user()?->hasRole(Role::admin->value) ?? false;
    }
    public static function canCreate(): bool
    {
        return auth()->user()?->hasRole(Role::admin->value) ?? false;
    }

    public static function canEdit($record): bool
    {
        return auth()->user()?->hasRole(Role::admin->value) ?? false;
    }
    public static function canDelete($record): bool
    {
        return auth()->user()?->hasRole(Role::admin->value) ?? false;
    }

    public static function getPluralModelLabel(): string
    {
        return __("contact-messages.contact-messages");
    }

    public static function getNavigationLabel(): string
    {
        return __("contact-messages.contact-messages");
    }

    public static function form(Form $form): Form
    {
        return $form->schema([
            Forms\Components\Section::make(__("contact-messages.details"))
                ->description(__("contact-messages.details-description"))
                ->aside()
                ->schema([
                    Forms\Components\TextInput::make("name")
                        ->label(__("contact-messages.name"))
                        ->required()
                        ->maxLength(255),

                    Forms\Components\TextInput::make("email")
                        ->label(__("contact-messages.email"))
                        ->email()
                        ->required()
                        ->maxLength(255),

                    Forms\Components\TextInput::make("phone_number")
                        ->label(__("contact-messages.phone-number"))
                        ->required()
                        ->maxLength(255),

                    Forms\Components\TextInput::make("subject")
                        ->label(__("contact-messages.subject"))
                        ->required()
                        ->maxLength(255),

                    Forms\Components\Textarea::make("message")
                        ->label(__("contact-messages.message"))
                        ->required(),
                ]),
        ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->columns([
                Tables\Columns\TextColumn::make("name")
                    ->label(__("contact-messages.name"))
                    ->searchable(),

                Tables\Columns\TextColumn::make("email")
                    ->label(__("contact-messages.email"))
                    ->searchable(),

                Tables\Columns\TextColumn::make("phone_number")
                    ->label(__("contact-messages.phone-number"))
                    ->searchable(),

                Tables\Columns\TextColumn::make("subject")
                    ->label(__("contact-messages.subject"))
                    ->searchable(),

                Tables\Columns\TextColumn::make("message")
                    ->label(__("contact-messages.message"))
                    ->limit(50)
                    ->searchable(),

                Tables\Columns\TextColumn::make("created_at")
                    ->label(__("contact-messages.created_at"))
                    ->dateTime('M d, Y h:i A')
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),

                Tables\Columns\TextColumn::make("updated_at")
                    ->label(__("contact-messages.updated_at"))
                    ->dateTime('M d, Y h:i A')
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),
            ])
            ->filters([
                //
            ])
            ->actions([Tables\Actions\ViewAction::make()->slideOver()]);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            "index" => Pages\ListContactMessages::route("/"),
        ];
    }
}
